<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;

/**
 * OfferReport
 *
 * @ORM\Table(name="offer_reports")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class OfferReport
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"companyOfferReports"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="market_segment_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyOfferReports"})
     */
    private $marketSegmentId;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"companyOfferReports"})
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=6)
     *
     * @Expose
     * @AnnotationGroups({"companyOfferReports"})
     */
    private $code;

    /**
     * @var float
     *
     * @ORM\Column(name="price", type="decimal", precision=9, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"companyOfferReports"})
     */
    private $price;


    /**
     * @ORM\ManyToOne(targetEntity="MarketSegment", inversedBy="offerReports")
     * @ORM\JoinColumn(name="market_segment_id", referencedColumnName="id")
     */
    protected $marketSegment;


    /**
     * @ORM\OneToMany(targetEntity="CompanyOfferReport", mappedBy="report")
     */
    private $companyOfferReports;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Report
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set code
     *
     * @param string $code
     * @return Report
     */
    public function setCode($code)
    {
        $this->code = $code;
    
        return $this;
    }

    /**
     * Get code
     *
     * @return string 
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set price
     *
     * @param float $price
     * @return Report
     */
    public function setPrice($price)
    {
        $this->price = $price;
    
        return $this;
    }

    /**
     * Get price
     *
     * @return float 
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->companies = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Set marketSegmentId
     *
     * @param integer $marketSegmentId
     * @return OfferReport
     */
    public function setMarketSegmentId($marketSegmentId)
    {
        $this->marketSegmentId = $marketSegmentId;
    
        return $this;
    }

    /**
     * Get marketSegmentId
     *
     * @return integer 
     */
    public function getMarketSegmentId()
    {
        return $this->marketSegmentId;
    }

    /**
     * Set marketSegment
     *
     * @param \VM\ApiBundle\Entity\MarketSegment $marketSegment
     * @return OfferReport
     */
    public function setMarketSegment(\VM\ApiBundle\Entity\MarketSegment $marketSegment = null)
    {
        $this->marketSegment = $marketSegment;
    
        return $this;
    }

    /**
     * Get marketSegment
     *
     * @return \VM\ApiBundle\Entity\MarketSegment 
     */
    public function getMarketSegment()
    {
        return $this->marketSegment;
    }

    /**
     * Add companyOfferReports
     *
     * @param \VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports
     * @return OfferReport
     */
    public function addCompanyOfferReport(\VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports)
    {
        $this->companyOfferReports[] = $companyOfferReports;
    
        return $this;
    }

    /**
     * Remove companyOfferReports
     *
     * @param \VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports
     */
    public function removeCompanyOfferReport(\VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports)
    {
        $this->companyOfferReports->removeElement($companyOfferReports);
    }

    /**
     * Get companyOfferReports
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyOfferReports()
    {
        return $this->companyOfferReports;
    }
}